/*
 * Decompiled with CFR 0.152.
 */
package com.adryd.cauldron.api.config;

import com.adryd.cauldron.CauldronReference;
import com.adryd.cauldron.api.config.ConfigOptionBase;
import com.adryd.cauldron.api.config.IConfigOption;
import com.adryd.cauldron.api.keybind.KeybindAction;
import com.adryd.cauldron.api.keybind.KeybindContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Set;
import java.util.function.Consumer;

public class ConfigKeybind
extends ConfigOptionBase<ConfigKeybind>
implements IConfigOption {
    private final KeybindAction defaultAction;
    private final KeybindContext defaultContext;
    private final String defaultKeyBind;
    private final boolean defaultCancelVanilla;
    private final boolean defaultOrderSensitive;
    private KeybindAction action;
    private KeybindContext context;
    private String keyBind;
    private boolean cancelVanilla;
    private boolean orderSensitive;
    private Set<Consumer<Boolean>> callbacks;

    public ConfigKeybind(String configKey, String name, String keyBind, KeybindAction action, KeybindContext context, boolean cancelVanilla, boolean orderSensitive) {
        super(configKey, name);
        this.action = this.defaultAction = action;
        this.context = this.defaultContext = context;
        this.keyBind = this.defaultKeyBind = keyBind;
        this.cancelVanilla = this.defaultCancelVanilla = cancelVanilla;
        this.orderSensitive = this.defaultOrderSensitive = orderSensitive;
        this.callbacks = Set.of();
    }

    @Override
    public JsonElement toJsonElement() {
        JsonObject obj = new JsonObject();
        obj.addProperty("action", this.action.toString());
        obj.addProperty("context", this.context.toString());
        obj.addProperty("cancelVanilla", this.keyBind);
        obj.addProperty("keyBind", this.keyBind);
        obj.addProperty("cancelVanilla", Boolean.valueOf(this.cancelVanilla));
        obj.addProperty("orderSensitive", Boolean.valueOf(this.orderSensitive));
        return obj;
    }

    @Override
    public void fromJsonElement(JsonElement element) {
        if (element.isJsonObject()) {
            JsonObject object = (JsonObject)element;
            this.action = object.has("action") && object.get("action").isJsonPrimitive() && object.getAsJsonPrimitive("action").isString() ? KeybindAction.valueOf(object.get("action").getAsString()) : this.defaultAction;
            this.context = object.has("context") && object.get("context").isJsonPrimitive() && object.getAsJsonPrimitive("context").isString() ? KeybindContext.valueOf(object.get("context").getAsString()) : this.defaultContext;
            this.keyBind = object.has("keyBind") && object.get("keyBind").isJsonPrimitive() && object.getAsJsonPrimitive("keyBind").isString() ? object.getAsJsonPrimitive("keyBind").getAsString() : this.defaultKeyBind;
            this.cancelVanilla = object.has("cancelVanilla") && object.get("cancelVanilla").isJsonPrimitive() && object.getAsJsonPrimitive("cancelVanilla").isBoolean() ? object.getAsJsonPrimitive("cancelVanilla").getAsBoolean() : this.defaultCancelVanilla;
            this.orderSensitive = object.has("orderSensitive") && object.get("orderSensitive").isJsonPrimitive() && object.getAsJsonPrimitive("orderSensitive").isBoolean() ? object.getAsJsonPrimitive("orderSensitive").getAsBoolean() : this.defaultOrderSensitive;
        } else {
            CauldronReference.LOGGER.warn("Failed to read storage key \"{}\" as boolean", (Object)this.getKey());
        }
    }

    @Override
    public boolean isModified() {
        return this.action != this.defaultAction || this.context != this.defaultContext || this.orderSensitive != this.defaultOrderSensitive || this.cancelVanilla != this.defaultCancelVanilla || !this.keyBind.equals(this.defaultKeyBind);
    }

    @Override
    public void resetToDefault() {
        this.action = this.defaultAction;
        this.context = this.defaultContext;
        this.keyBind = this.defaultKeyBind;
        this.orderSensitive = this.defaultOrderSensitive;
        this.cancelVanilla = this.defaultCancelVanilla;
    }

    public KeybindAction getAction() {
        return this.action;
    }

    public String getKeyBind() {
        return this.keyBind;
    }

    public KeybindContext getContext() {
        return this.context;
    }

    public boolean isOrderSensitive() {
        return this.orderSensitive;
    }

    public boolean isCancelVanilla() {
        return this.cancelVanilla;
    }

    public void addCallback(Consumer<Boolean> method) {
        this.callbacks.add(method);
    }
}

