/*
 * Decompiled with CFR 0.152.
 */
package com.adryd.cauldron.impl.command;

import com.adryd.cauldron.api.command.CauldronClientCommandSource;
import com.adryd.cauldron.api.command.ClientCommandManager;
import com.adryd.cauldron.mixin.command.IMixinClientPlayerEntity;
import com.google.common.collect.Maps;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_2164;
import net.minecraft.class_2172;
import net.minecraft.class_2321;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class ClientCommandInternals {
    private static final class_310 client = class_310.method_1551();

    private static boolean hasCommands() {
        return ClientCommandManager.DISPATCHER.getRoot().getChildren().size() > 1;
    }

    public static void execute(String command, CauldronClientCommandSource source) {
        block6: {
            StringReader stringReader = new StringReader(command);
            if (stringReader.canRead() && stringReader.peek() == '.') {
                stringReader.skip();
            }
            try {
                ClientCommandManager.DISPATCHER.execute(stringReader, (Object)source);
            }
            catch (class_2164 commandException) {
                source.sendError(commandException.method_9199());
            }
            catch (CommandSyntaxException commandException) {
                source.sendError(class_2564.method_10883((Message)commandException.getRawMessage()));
                if (commandException.getInput() == null || commandException.getCursor() < 0) break block6;
                int position = Math.min(commandException.getInput().length(), commandException.getCursor());
                class_5250 mutableText = class_2561.method_43470((String)"").method_27692(class_124.field_1080).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11745, command)));
                if (position > 10) {
                    mutableText.method_27693("...");
                }
                mutableText.method_27693(commandException.getInput().substring(Math.max(0, position - 10), position));
                if (position < commandException.getInput().length()) {
                    class_5250 text = class_2561.method_43470((String)commandException.getInput().substring(position)).method_27695(new class_124[]{class_124.field_1061, class_124.field_1073});
                    mutableText.method_10852((class_2561)text);
                }
                mutableText.method_10852((class_2561)class_2561.method_43471((String)"command.context.here").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}));
                source.sendError((class_2561)mutableText);
            }
        }
    }

    public static boolean executeCommand(String message, class_746 playerEntity, @Nullable class_2561 preview) {
        if (!ClientCommandInternals.hasCommands()) {
            return false;
        }
        if (message.startsWith(Character.toString('.')) && !message.startsWith("./")) {
            if (message.startsWith("." + Character.toString('.'))) {
                String newMessage = message.substring(1);
                ((IMixinClientPlayerEntity)playerEntity).invokeSendChatMessagePacket(newMessage, preview);
                return true;
            }
            ClientCommandInternals.execute(message, new CauldronClientCommandSource(client));
            return true;
        }
        return false;
    }

    public static boolean shouldShowSuggestions(String message) {
        if (!ClientCommandInternals.hasCommands() || message.startsWith(Character.toString('.') + ".") || message.startsWith("./")) {
            return false;
        }
        return message.startsWith(Character.toString('.'));
    }

    public static RootCommandNode<class_2172> getCommandTree() {
        HashMap map = Maps.newHashMap();
        RootCommandNode rootCommandNode = new RootCommandNode();
        map.put(ClientCommandManager.DISPATCHER.getRoot(), rootCommandNode);
        ClientCommandInternals.createCommandTree((CommandNode<CauldronClientCommandSource>)ClientCommandManager.DISPATCHER.getRoot(), (CommandNode<class_2172>)rootCommandNode, new CauldronClientCommandSource(client), map);
        return rootCommandNode;
    }

    private static void createCommandTree(CommandNode<CauldronClientCommandSource> tree, CommandNode<class_2172> result, CauldronClientCommandSource source, Map<CommandNode<CauldronClientCommandSource>, CommandNode<class_2172>> resultNodes) {
        for (CommandNode commandNode : tree.getChildren()) {
            RequiredArgumentBuilder requiredArgumentBuilder;
            if (!commandNode.canUse((Object)source)) continue;
            ArgumentBuilder argumentBuilder = commandNode.createBuilder();
            argumentBuilder.executes(context -> 0);
            if (argumentBuilder.getCommand() != null) {
                argumentBuilder.executes(context -> 0);
            }
            if (argumentBuilder instanceof RequiredArgumentBuilder && (requiredArgumentBuilder = (RequiredArgumentBuilder)argumentBuilder).getSuggestionsProvider() != null) {
                requiredArgumentBuilder.suggests(class_2321.method_10026((SuggestionProvider)requiredArgumentBuilder.getSuggestionsProvider()));
            }
            if (argumentBuilder.getRedirect() != null) {
                argumentBuilder.redirect(resultNodes.get(argumentBuilder.getRedirect()));
            }
            requiredArgumentBuilder = argumentBuilder.build();
            resultNodes.put((CommandNode<CauldronClientCommandSource>)commandNode, (CommandNode<class_2172>)requiredArgumentBuilder);
            result.addChild((CommandNode)requiredArgumentBuilder);
            if (commandNode.getChildren().isEmpty()) continue;
            ClientCommandInternals.createCommandTree((CommandNode<CauldronClientCommandSource>)commandNode, (CommandNode<class_2172>)requiredArgumentBuilder, source, resultNodes);
        }
    }
}

