/*
 * Decompiled with CFR 0.152.
 */
package com.adryd.cauldron.api.config;

import com.adryd.cauldron.CauldronReference;
import com.adryd.cauldron.api.config.IConfigOption;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface IConfigOptionNested
extends IConfigOption {
    default public Map<String, IConfigOption> getConfigOptionMap() {
        HashMap<String, IConfigOption> resultMap = new HashMap<String, IConfigOption>();
        for (IConfigOption option : this.getConfigOptionList()) {
            resultMap.put(option.getKey(), option);
        }
        return resultMap;
    }

    public List<IConfigOption> getConfigOptionList();

    @Override
    default public boolean isModified() {
        for (IConfigOption option : this.getConfigOptionList()) {
            if (!option.isModified()) continue;
            return true;
        }
        return false;
    }

    @Override
    default public void resetToDefault() {
        for (IConfigOption option : this.getConfigOptionList()) {
            option.resetToDefault();
        }
    }

    @Override
    default public void fromJsonElement(JsonElement element) {
        if (element.isJsonObject()) {
            JsonObject object = element.getAsJsonObject();
            Map<String, IConfigOption> configOptionMap = this.getConfigOptionMap();
            for (String key : object.keySet()) {
                if (!object.get(key).isJsonObject() || !configOptionMap.containsKey(key)) continue;
                configOptionMap.get(key).fromJsonElement(object.get(key));
            }
        } else {
            CauldronReference.LOGGER.warn("Failed to read storage key \"{}\" as object", (Object)this.getKey());
        }
    }

    @Override
    default public JsonElement toJsonElement() {
        JsonObject object = new JsonObject();
        for (IConfigOption option : this.getConfigOptionList()) {
            if (!option.isModified()) continue;
            object.add(option.getKey(), option.toJsonElement());
        }
        return object;
    }
}

