package com.adryd.cauldron.mixin.command;

import com.adryd.cauldron.impl.command.ClientCommandInternals;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.suggestion.Suggestions;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2172;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_4717;

@Mixin(class_4717.class)
public abstract class MixinCommandSuggestor {
    @Final
    @Shadow
    class_310 client;

    @Shadow
    class_4717.class_464 window;

    @Shadow
    boolean completingSuggestions;

    @Final
    @Shadow
    class_342 textField;

    @Shadow
    private ParseResults<class_2172> parse;

    @Shadow
    private CompletableFuture<Suggestions> pendingSuggestions;

    @Shadow
    protected abstract void show();

    @Inject(method = "refresh", at = @At(value = "INVOKE", target = "Lcom/mojang/brigadier/StringReader;canRead()Z", remap = false), cancellable = true, locals = LocalCapture.CAPTURE_FAILHARD)

    private void commandSuggestions(CallbackInfo ci, String string, StringReader stringReader) {
        if (stringReader.canRead(string.length())
                && ClientCommandInternals.shouldShowSuggestions(stringReader.getString())
                && this.client.field_1724 != null) {
            stringReader.setCursor(stringReader.getCursor() + 1);
            CommandDispatcher<class_2172> dispatcher = new CommandDispatcher<>(ClientCommandInternals.getCommandTree());
            if (this.parse == null) {
                this.parse = dispatcher.parse(stringReader, client.method_1562().method_2875());
            }
            if (textField.method_1881() >= 1 && (this.window == null || !this.completingSuggestions)) {
                this.pendingSuggestions = dispatcher.getCompletionSuggestions(this.parse, textField.method_1881());
                this.pendingSuggestions.thenRun(() -> {
                    if (this.pendingSuggestions.isDone()) {
                        this.show();
                    }
                });
            }
            ci.cancel();
        }
    }
}
