package com.adryd.cauldron.impl.command;

import com.adryd.cauldron.api.command.CauldronClientCommandSource;
import com.google.common.collect.Maps;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import net.minecraft.class_124;
import net.minecraft.class_2164;
import net.minecraft.class_2172;
import net.minecraft.class_2321;
import net.minecraft.class_2558;
import net.minecraft.class_2564;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2797;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.text.*;
import java.util.HashMap;
import java.util.Map;

import static com.adryd.cauldron.api.command.ClientCommandManager.COMMAND_PREFIX;
import static com.adryd.cauldron.api.command.ClientCommandManager.DISPATCHER;

public class ClientCommandInternals {
    private static final class_310 client = class_310.method_1551();

    private static boolean hasCommands() {
        // if more than just the help command is registered
        return (DISPATCHER.getRoot().getChildren().size() > 1);
    }

    public static void execute(String command, CauldronClientCommandSource source) {
        StringReader stringReader = new StringReader(command);
        if (stringReader.canRead() && stringReader.peek() == COMMAND_PREFIX) {
            stringReader.skip();
        }
        try {
            DISPATCHER.execute(stringReader, source);
        } catch (class_2164 commandException) {
            source.sendError(commandException.method_9199());
        } catch (CommandSyntaxException commandException) {
            source.sendError(class_2564.method_10883(commandException.getRawMessage()));
            if (commandException.getInput() != null && commandException.getCursor() >= 0) {
                int position = Math.min(commandException.getInput().length(), commandException.getCursor());
                class_5250 mutableText = new class_2585("").method_27692(class_124.field_1080).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11745, command)));
                if (position > 10) {
                    mutableText.method_27693("...");
                }
                mutableText.method_27693(commandException.getInput().substring(Math.max(0, position - 10), position));
                if (position < commandException.getInput().length()) {
                    class_5250 text = new class_2585(commandException.getInput().substring(position)).method_27695(class_124.field_1061, class_124.field_1073);
                    mutableText.method_10852(text);
                }
                mutableText.method_10852(new class_2588("command.context.here").method_27695(class_124.field_1061, class_124.field_1056));
                source.sendError(mutableText);
            }
        }
    }

    // Used by MixinCommandSuggestor
    public static boolean executeCommand(String message) {
        if (!hasCommands()) return false;
        // allow people to send "./" often used to show people how to use a server command
        if (message.startsWith(Character.toString(COMMAND_PREFIX)) && !message.startsWith(COMMAND_PREFIX + "/")) {
            if (message.startsWith(COMMAND_PREFIX + Character.toString(COMMAND_PREFIX))) {
                // allow people to send "." or messages prefixed with "." in chat, sometimes used to check if someone's cheating or something
                client.method_1562().method_2883(new class_2797(message.substring(1)));
                return true;
            }
            execute(message, new CauldronClientCommandSource(client));
            return true;
        }
        return false;
    }

    // Used by MixinCommandSuggestor
    public static boolean shouldShowSuggestions(String message) {
        if (!hasCommands() || message.startsWith(Character.toString(COMMAND_PREFIX) + COMMAND_PREFIX) || message.startsWith(COMMAND_PREFIX + "/"))
            return false;
        return message.startsWith(Character.toString(COMMAND_PREFIX));
    }

    // Used by MixinCommandSuggestor
    // Copied from vanilla
    public static RootCommandNode<class_2172> getCommandTree() {
        HashMap<CommandNode<CauldronClientCommandSource>, CommandNode<class_2172>> map = Maps.newHashMap();
        RootCommandNode<class_2172> rootCommandNode = new RootCommandNode<>();
        map.put(DISPATCHER.getRoot(), rootCommandNode);
        createCommandTree(DISPATCHER.getRoot(), rootCommandNode, new CauldronClientCommandSource(client), map);
        return rootCommandNode;
    }

    // Copied from vanilla
    private static void createCommandTree(CommandNode<CauldronClientCommandSource> tree, CommandNode<class_2172> result, CauldronClientCommandSource source, Map<CommandNode<CauldronClientCommandSource>, CommandNode<class_2172>> resultNodes) {
        for (CommandNode<CauldronClientCommandSource> commandNode : tree.getChildren()) {
            if (commandNode.canUse(source)) {
                @SuppressWarnings({"unchecked", "rawtypes"}) ArgumentBuilder<class_2172, ?> argumentBuilder = (ArgumentBuilder) commandNode.createBuilder();
                argumentBuilder.executes((context) -> 0);
                if (argumentBuilder.getCommand() != null) {
                    argumentBuilder.executes((context) -> 0);
                }

                if (argumentBuilder instanceof RequiredArgumentBuilder) {
                    @SuppressWarnings({"unchecked", "rawtypes"}) RequiredArgumentBuilder<class_2172, ?> requiredArgumentBuilder = (RequiredArgumentBuilder) argumentBuilder;
                    if (requiredArgumentBuilder.getSuggestionsProvider() != null) {
                        requiredArgumentBuilder.suggests(class_2321.method_10026(requiredArgumentBuilder.getSuggestionsProvider()));
                    }
                }

                if (argumentBuilder.getRedirect() != null) {
                    argumentBuilder.redirect(resultNodes.get(argumentBuilder.getRedirect()));
                }

                CommandNode<class_2172> requiredArgumentBuilder = argumentBuilder.build();
                resultNodes.put(commandNode, requiredArgumentBuilder);
                result.addChild(requiredArgumentBuilder);
                if (!commandNode.getChildren().isEmpty()) {
                    createCommandTree(commandNode, requiredArgumentBuilder, source, resultNodes);
                }
            }
        }
    }
}
