package com.adryd.cauldron.api.render.helper;

import com.adryd.cauldron.api.util.Color4f;
import com.adryd.cauldron.mixin.render.IMixinBufferBuilder;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_293;
import net.minecraft.class_296;
import org.jetbrains.annotations.Nullable;

public class BufferBuilderProxy extends class_287 {
    public static final int MAX_BUFFER_SIZE = 2097152;

    @Nullable
    private class_293 vertexFormat;

    private double posX;
    private double posY;
    private double posZ;
    private float colorR;
    private float colorG;
    private float colorB;
    private float colorA;
    private float normalX;
    private float normalY;
    private float normalZ;

    public BufferBuilderProxy(int initialCapacity) {
        super(initialCapacity);
    }

    public BufferBuilderProxy method_22912(double x, double y, double z) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        return this;
    }

    public BufferBuilderProxy vertex(class_243 pos) {
        this.posX = pos.field_1352;
        this.posY = pos.field_1351;
        this.posZ = pos.field_1350;
        return this;
    }

    public BufferBuilderProxy method_22915(float r, float g, float b, float a) {
        this.colorR = r;
        this.colorG = g;
        this.colorB = b;
        this.colorA = a;
        return this;
    }

    public BufferBuilderProxy color(Color4f color) {
        this.colorR = color.r;
        this.colorG = color.g;
        this.colorB = color.b;
        this.colorA = color.a;
        return this;
    }

    public BufferBuilderProxy method_22914(float x, float y, float z) {
        this.normalX = x;
        this.normalY = y;
        this.normalZ = z;
        return this;
    }

    public void method_1328(class_293.class_5596 drawMode, class_293 vertexFormat) {
        super.method_1328(drawMode, vertexFormat);
        this.vertexFormat = vertexFormat;
    }

    public void method_1344() {
        for (class_296 element : ((IMixinBufferBuilder) this).getFormat().method_1357()) {
            switch (element.method_1382()) {
                case field_1633 -> super.vertex(this.posX, this.posY, this.posZ);
                case field_1632 -> super.color(this.colorR, this.colorG, this.colorB, this.colorA);
                case field_1635 -> super.normal(this.normalX, this.normalY, this.normalZ);
            }
        }
        super.method_1344();
    }
}
