package com.adryd.cauldron.impl.render.helpers;

import com.adryd.cauldron.api.render.helper.IOverlayRenderHandler;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import org.joml.Matrix4f;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_3695;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_758;

public class OverlayRenderInternals {
    private static final Set<IOverlayRenderHandler> overlayRenderHandlers = new HashSet<>();

    public static void addRenderer(IOverlayRenderHandler renderer) {
        overlayRenderHandlers.add(renderer);
    }

    public static void afterChunkDebug(class_4587 matrices, Matrix4f positionMatrix, class_4184 camera, float tickDelta, class_3695 profiler) {
        profiler.method_15405("CauldronOverlayRenderers");
        if (!overlayRenderHandlers.isEmpty()) {
            // Update
            for (IOverlayRenderHandler overlayRenderer : overlayRenderHandlers) {
                overlayRenderer.setup();
                if (overlayRenderer.shouldUpdate(camera)) {
                    overlayRenderer.update(matrices, camera, tickDelta);
                }
            }

            float fogStart = RenderSystem.getShaderFogStart();
            class_758.method_23792();
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate(GlStateManager.class_4535.SRC_ALPHA, GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, GlStateManager.class_4535.ONE, GlStateManager.class_4534.ZERO);
            RenderSystem.setShaderColor(1f, 1f, 1f, 1f);

            // Render
            for (IOverlayRenderHandler overlayRenderer : overlayRenderHandlers) {
                if (overlayRenderer.shouldRender()) {
                    // Normalize
//                    RenderSystem.disableTexture();
                    RenderSystem.disableCull();
                    RenderSystem.enableDepthTest();
                    RenderSystem.depthMask(true);
                    RenderSystem.polygonOffset(-3f, -3f);
                    RenderSystem.enablePolygonOffset();

                    // TODO: Render objects will handle this
                    RenderSystem.lineWidth(6.0f);
                    overlayRenderer.render(tickDelta, camera);
                }
            }

            // Set back to as things were before
            RenderSystem.polygonOffset(0f, 0f);
            RenderSystem.disablePolygonOffset();
            RenderSystem.setShaderColor(1f, 1f, 1f, 1f);
            RenderSystem.disableBlend();
            RenderSystem.enableDepthTest();
            RenderSystem.enableCull();
            RenderSystem.depthMask(true);
//            RenderSystem.enableTexture();
            RenderSystem.setShaderFogStart(fogStart);
        }
    }
}
