/*
 * Decompiled with CFR 0.152.
 */
package com.adryd.cauldron.impl.render.helpers;

import com.adryd.cauldron.api.render.helper.IOverlayRenderHandler;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_3695;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_758;
import org.joml.Matrix4f;

public class OverlayRenderInternals {
    private static final Set<IOverlayRenderHandler> overlayRenderHandlers = new HashSet<IOverlayRenderHandler>();

    public static void addRenderer(IOverlayRenderHandler renderer) {
        overlayRenderHandlers.add(renderer);
    }

    public static void afterChunkDebug(class_4587 matrices, Matrix4f positionMatrix, class_4184 camera, float tickDelta, class_3695 profiler) {
        profiler.method_15405("CauldronOverlayRenderers");
        if (!overlayRenderHandlers.isEmpty()) {
            for (IOverlayRenderHandler overlayRenderer : overlayRenderHandlers) {
                overlayRenderer.setup();
                if (!overlayRenderer.shouldUpdate(camera)) continue;
                overlayRenderer.update(matrices, camera, tickDelta);
            }
            float fogStart = RenderSystem.getShaderFogStart();
            class_758.method_23792();
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            for (IOverlayRenderHandler overlayRenderer : overlayRenderHandlers) {
                if (!overlayRenderer.shouldRender()) continue;
                RenderSystem.disableCull();
                RenderSystem.enableDepthTest();
                RenderSystem.depthMask((boolean)true);
                RenderSystem.polygonOffset((float)-3.0f, (float)-3.0f);
                RenderSystem.enablePolygonOffset();
                RenderSystem.lineWidth((float)6.0f);
                overlayRenderer.render(tickDelta, camera);
            }
            RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
            RenderSystem.disablePolygonOffset();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
            RenderSystem.enableDepthTest();
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.setShaderFogStart((float)fogStart);
        }
    }
}

