package com.adryd.cauldron.api.command;


import com.google.common.collect.Lists;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2172;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_338;
import net.minecraft.class_3414;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_640;
import net.minecraft.class_746;
import net.minecraft.class_7699;
import net.minecraft.class_7923;

public class CauldronClientCommandSource implements class_2172 {
    private final class_310 client;
    private final class_338 chatHud;
    private final class_746 player;

    public CauldronClientCommandSource(class_310 client) {
        this.client = client;
        this.player = this.client.field_1724;
        this.chatHud = this.client.field_1705.method_1743();
    }

    public void sendFeedback(class_2561 message) {
        this.chatHud.method_1812(message);
    }

    public void sendError(class_2561 message) {
        this.chatHud.method_1812(class_2561.method_43470("").method_10852(message).method_27692(class_124.field_1061));
    }

    public class_310 getClient() {
        return this.client;
    }

    @Override
    public Collection<String> method_9267() {
        return null;
    }

    @Override
    public Stream<class_2960> method_9254() {
        return class_7923.field_41172.method_10220().map(class_3414::method_14833);
    }

    @Override
    public Stream<class_2960> method_9273() {
        return null;
    }

    @Override
    public CompletableFuture<Suggestions> method_9261(CommandContext<?> context) {
        return null;
    }

    @Override
    public Set<class_5321<class_1937>> method_29310() {
        return this.client.method_1562().method_29356();
    }

    @Override
    public class_5455 method_30497() {
        return this.client.method_1562().method_29091();
    }

    @Override
    public class_7699 method_45549() {
        return this.client.method_1562().method_45735();
    }

    @Override
    public boolean method_9259(int level) {
        return true;
    }

    public class_746 getPlayer() {
        return this.player;
    }

    private static String format(double d) {
        return String.format(Locale.ROOT, "%.2f", d);
    }

    private static String format(int i) {
        return Integer.toString(i);
    }

    // Vanilla code from ClientCommandManager
    @Override
    public Collection<class_2172.class_2173> method_17771() {
        class_239 hitResult = this.client.field_1765;
        if (hitResult != null && hitResult.method_17783() == class_239.class_240.field_1332) {
            class_2338 blockPos = ((class_3965) hitResult).method_17777();
            return Collections.singleton(new class_2172.class_2173(format(blockPos.method_10263()), format(blockPos.method_10264()), format(blockPos.method_10260())));
        } else {
            return class_2172.super.method_17771();
        }
    }

    // Vanilla code from ClientCommandManager
    @Override
    public Collection<class_2172.class_2173> method_17772() {
        class_239 hitResult = this.client.field_1765;
        if (hitResult != null && hitResult.method_17783() == class_239.class_240.field_1332) {
            class_243 vec3d = hitResult.method_17784();
            return Collections.singleton(new class_2172.class_2173(format(vec3d.field_1352), format(vec3d.field_1351), format(vec3d.field_1350)));
        } else {
            return class_2172.super.method_17772();
        }
    }

    // Vanilla code from ClientCommandManager
    @Override
    public CompletableFuture<Suggestions> method_41213(class_5321<? extends class_2378<?>> registryRef, class_2172.class_7078 suggestedIdType, SuggestionsBuilder builder, CommandContext<?> context) {
        return (CompletableFuture<Suggestions>) this.method_30497().method_33310(registryRef).map(registry -> {
            this.method_41214(registry, suggestedIdType, builder);
            return builder.buildFuture();
        }).orElseGet(() -> this.method_9261(context));
    }

    // Vanilla code from ClientCommandManager
    @Override
    public Collection<String> method_9262() {
        List<String> list = Lists.newArrayList();

        for(class_640 playerListEntry : this.client.method_1562().method_2880()) {
            list.add(playerListEntry.method_2966().getName());
        }

        return list;
    }

    // Vanilla code from ClientCommandManager
    @Override
    public Collection<String> method_9269() {
        return (Collection<String>)(this.client.field_1765 != null && this.client.field_1765.method_17783() == class_239.class_240.field_1331
                ? Collections.singleton(((class_3966)this.client.field_1765).method_17782().method_5845())
                : Collections.emptyList());
    }

    // Just return player names since we don't want to notify the server of client commands
    @Override
    public Collection<String> method_44750() {
        return this.method_9262();
    }
}
