package com.adryd.cauldron.api.render.helper;

import com.mojang.blaze3d.systems.RenderSystem;
import org.joml.Quaternionf;

import java.util.function.Supplier;
import net.minecraft.class_243;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_5944;

public class RenderObject {
    protected class_293.class_5596 drawMode;
    protected class_293 vertexFormat;
    protected Supplier<class_5944> shaderSupplier;
    protected BufferBuilderProxy bufferBuilder;
    private class_291 vertexBuffer;

    private class_243 lastDrawCameraPos;


    public RenderObject(class_293.class_5596 drawMode, class_293 vertexFormat, Supplier<class_5944> shaderSupplier) {
        this.bufferBuilder = new BufferBuilderProxy(BufferBuilderProxy.MAX_BUFFER_SIZE);
        this.drawMode = drawMode;
        this.vertexFormat = vertexFormat;
        this.shaderSupplier = shaderSupplier;
        this.lastDrawCameraPos = class_243.field_1353;
    }

    public BufferBuilderProxy startBuffer() {
        this.bufferBuilder.method_1328(this.drawMode, this.vertexFormat);
        return this.bufferBuilder;
    }

    public void endBuffer(class_4184 camera) {
        // Set last draw camera position
        this.lastDrawCameraPos = camera.method_19326();
        this.vertexBuffer.method_1353();
        this.vertexBuffer.method_1352(this.bufferBuilder.method_1326());
        class_291.method_1354();
    }

    public void draw(float tickDelta, class_4184 camera) {
        this.beforeDraw();

        // Set shader
        RenderSystem.setShader(this.shaderSupplier);

        // Get model view stack
        class_4587 modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.method_22903();
        // Translate to new camera position
        modelViewStack.method_22904(this.lastDrawCameraPos.field_1352-camera.method_19326().field_1352, this.lastDrawCameraPos.field_1351-camera.method_19326().field_1351, this.lastDrawCameraPos.field_1350-camera.method_19326().field_1350);
        // Math is hard
        // modelViewStack.multiply(new Quaternionf().rotationXYZ(camera.getPitch() * (float) (Math.PI / 180.0), camera.getYaw() * (float) (Math.PI / 180.0), 0.0F));

        // Draw
        this.vertexBuffer.method_1353();
        this.vertexBuffer.method_34427(modelViewStack.method_23760().method_23761(), RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
        class_291.method_1354();

        modelViewStack.method_22909();

        this.afterDraw();
    }

    protected void afterDraw() {
    }

    protected void beforeDraw() {
    }

    public void setup() {
        if (this.vertexBuffer != null) return;
        this.vertexBuffer = new class_291(class_291.class_8555.field_44794);
    }
}
