package com.adryd.cauldron.api.render.helper;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1159;
import net.minecraft.class_4587;

public abstract class OverlayRendererBase implements IOverlayRenderHandler {
    protected final List<RenderObject> renderObjects;

    public OverlayRendererBase() {
        this.renderObjects = new ArrayList<>();
    }

    @Override
    public void render(class_4587 matrices, class_1159 positionMatrix, float tickDelta) {
        for (RenderObject renderObject : renderObjects) {
            renderObject.draw(matrices, positionMatrix);
        }
    }

    @Override
    public void setup() {
        for (RenderObject renderObject : this.renderObjects) {
            renderObject.setup();
        }
    }
}
