/*
 * Decompiled with CFR 0.152.
 */
package com.adryd.cauldron.api.config;

import com.adryd.cauldron.CauldronReference;
import com.adryd.cauldron.api.config.IConfigOption;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_310;

public class ConfigFile {
    private static final File configDir = new File(class_310.method_1551().field_1697, "config");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final File file;
    private final List<IConfigOption> configOptions = new ArrayList<IConfigOption>();
    private final boolean keepRoot;
    private boolean loaded = false;
    private JsonObject root;

    public ConfigFile(String id) {
        this(id, false);
    }

    public ConfigFile(String id, boolean keepRoot) {
        this.file = new File(configDir, id + ".json");
        this.keepRoot = keepRoot;
        this.read();
    }

    public void read() {
        if (!this.loaded && this.file.exists() && this.file.isFile() && this.file.canRead()) {
            String fileName = this.file.getAbsolutePath();
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(this.file), StandardCharsets.UTF_8);){
                JsonElement element = JsonParser.parseReader((Reader)reader);
                if (element != null && element.isJsonObject()) {
                    this.root = (JsonObject)element;
                    this.loaded = true;
                    for (IConfigOption option : this.configOptions) {
                        option.fromJsonElement(this.root.get(option.getKey()));
                    }
                }
            }
            catch (Exception e) {
                CauldronReference.LOGGER.error("Failed to parse JSON file \"{}\"", (Object)fileName, (Object)e);
            }
        } else {
            CauldronReference.LOGGER.warn("Tried to re-read config file \"{}\"", (Object)this.file.getAbsolutePath());
        }
    }

    public void write() {
        JsonObject root = new JsonObject();
        if (this.loaded && this.keepRoot) {
            root = this.root;
        }
        for (IConfigOption option : this.configOptions) {
            root.add(option.getKey(), option.toJsonElement());
        }
        File tmpFile = new File(this.file.getParentFile(), this.file.getName() + ".tmp");
        if (tmpFile.exists()) {
            tmpFile = new File(this.file.getParentFile(), this.file.getName() + "." + UUID.randomUUID() + ".tmp");
        }
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(tmpFile), StandardCharsets.UTF_8);
            writer.write(GSON.toJson((JsonElement)root));
            writer.close();
            if (this.file.exists() && this.file.isFile() && !this.file.delete()) {
                CauldronReference.LOGGER.error("Failed to delete file \"{}\"", (Object)this.file.getAbsolutePath());
            } else {
                tmpFile.renameTo(this.file);
            }
        }
        catch (Exception e) {
            CauldronReference.LOGGER.error("Failed to write JSON to file \"{}\"", (Object)tmpFile.getAbsolutePath(), (Object)e);
        }
    }

    public void addConfig(IConfigOption option) {
        this.configOptions.add(option);
        if (this.loaded) {
            option.fromJsonElement(this.root.get(option.getKey()));
        }
    }

    public void addConfigs(List<IConfigOption> options) {
        this.configOptions.addAll(options);
        if (this.loaded) {
            for (IConfigOption option : options) {
                option.fromJsonElement(this.root.get(option.getKey()));
            }
        }
    }
}

