package com.adryd.cauldron.api.render.helper;

import java.util.function.Supplier;
import net.minecraft.class_1159;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_4587;
import net.minecraft.class_5944;

public class RenderObject {
    protected class_293.class_5596 drawMode;
    protected class_293 vertexFormat;
    protected Supplier<class_5944> shaderSupplier;
    protected BufferBuilderProxy bufferBuilder;
    private class_291 vertexBuffer;

    public RenderObject(class_293.class_5596 drawMode, class_293 vertexFormat, Supplier<class_5944> shaderSupplier) {
        this.bufferBuilder = new BufferBuilderProxy(BufferBuilderProxy.MAX_BUFFER_SIZE);
        this.drawMode = drawMode;
        this.vertexFormat = vertexFormat;
        this.shaderSupplier = shaderSupplier;
    }

    public BufferBuilderProxy startBuffer() {
        this.bufferBuilder.method_1328(this.drawMode, this.vertexFormat);
        return this.bufferBuilder;
    }

    public void endBuffer() {
        this.vertexBuffer.method_1353();
        this.vertexBuffer.method_1352(this.bufferBuilder.method_1326());
        class_291.method_1354();
    }

    public void draw(class_4587 matrices, class_1159 positionMatrix) {
        this.beforeDraw();
        this.vertexBuffer.method_1353();
        this.vertexBuffer.method_34427(matrices.method_23760().method_23761(), positionMatrix, this.shaderSupplier.get());
        class_291.method_1354();
        this.afterDraw();
    }

    protected void afterDraw() {
    }

    protected void beforeDraw() {
    }

    public void setup() {
        if (this.vertexBuffer != null) return;
        this.vertexBuffer = new class_291();
    }
}
